#version 140
#extension GL_EXT_gpu_shader4 : enable
// Koch GridMod01.fsh
//https://www.shadertoy.com/view/NslBR7
// Licence CC0
// Adapted, trivialy, for use in VGHD player
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed* 0.314159
#define iResolution u_WindowSize

//uniform float iTime;
//uniform vec2 iResolution;
uniform vec4 iDate;

#define iMouse AUTO_MOUSE
#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#ifdef GL_ES
//precision mediump float;
//#endif
vec4 texture2D_Fract(sampler2D sampler,vec2 P)
 { return texture2D(sampler,fract(P));
 }
uniform sampler2D iChannel0;






//NOTE(): Show how bending space of uv coordinates are can be used
//        to tiles arbitrary shapes. This will use a Koch curve.

#define PI32 3.141592653589793238462

//#ifdef GL_ES
//precision mediump float;
//#endif

/*
uniform vec2 u_resolution;
uniform vec2 u_mouse;
uniform float u_time;
*/
vec2 GetNormal(float angle)
{
    return vec2(sin(angle), cos(angle));
}
void main( void )

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    float u_time = iTime;
    vec2 u_mouse = iMouse.xy;

    vec2 u_resolution = iResolution.xy;
    
    float scale = 1.5;
    vec2 st = gl_FragCoord.xy/u_resolution.xy; //NOTE: Normalization
    st.x *= u_resolution.x/u_resolution.y; //NOTE(): Aspect ratio adjustment
    vec2 uv = (gl_FragCoord.xy - 0.5 * u_resolution.xy) / u_resolution.y; //NOTE(): Aspect ratio adjustment and normailization
    uv *= scale;
    vec2 mouse = (u_mouse.xy / u_resolution.xy)* 4.0 - 2.0;
    mouse.x = min(abs(mouse.x),1.0);
    mouse.y = min(abs(mouse.y),1.0);
    vec3 color = vec3(0.0);
    //-----
 
    uv.y += tan((5.0/6.0) *PI32 ) * 0.5;
    uv.x = abs(uv.x);
    vec2  normal = GetNormal(mouse.x * (5.0/6.0)* PI32);
    float dist   = dot(uv, normal);
    uv -= normal * max(0.0, dot(uv - vec2(0.5, 0.0), normal)) * 2.0;
    
    color.rg +=  max(0.5 * (sin(uv  + iTime) + 1.0), 0.6);
    
    color += smoothstep(0.001 + abs(dist) - 0.5 * normal.x , 0.0, abs(dist) - 0.5 * normal.x);
    
    //-----    
    
    /*
     Drawing a line segment.
     The way this works is by defining a range [-0.5, 0.5] and we look at the uv value
     of the fragment and compared it to the range. If the fragment is in range it is not
     changed by the clamp function. This means there are 2 cases uv is not clamped and uv is 
     clamped. Let's say uv is is not clamped. We take the difference of the uv and the uv after
     using clamp(which did nothing) which will end giving us a vector(0, 0). Then we get the
     distance of that uv(0,0) and the origin(0,0) which is zero. That gives us the value of our
     fragment, Black
     If the uv for the frag is outside then it is clamped which give us a length greater than zero.
     The steps above are repeated and the result is a distance a greater than 0 for pixel farther from
     the range. These framents are white.
    */
    
    float uvcompression = 1.0;
    normal = GetNormal(mouse.y * (2.0/3.0)*PI32);
    uv.x += 0.5;
    for(int i=0; i<3; i++)
    {
        uv *= 3.0;
        uvcompression *= 3.0;
        uv.x -= 1.5;
        uv.x = abs(uv.x);
        uv.x -= 0.5;
        uv -= normal    * min(0.0, dot(uv, normal)) * 2.0;
        //    rotation    mask (reflection)
    }
    
    dist = length(uv - vec2(clamp(uv.x, -1.0, 1.0), 0));
	color += min(0.6, dist); //NOTE(): Original line
    color += smoothstep(1.0/u_resolution.y, 0.0, dist/uvcompression); //TODO(): Explain this
    
    /* Visuealizing the uv coordinate space by filling red and green channels
          |------|------|
    Green | -x,y | x,y  | Yellow
     g    |  0,g | r,g  | rg
          -------+------|
     0    | -x,-y| x,-y | r
	Black |  0,0 | r,0  | Red
          |------|------|
    */
    
    vec2 uv1 = uv;
    uv1/= uvcompression;
    color -= texture(iChannel0, uv1 * 2.0-u_time*0.2).rgb * 0.5;
    
    
    //GRID (visualiz)
    vec3 grid = vec3(0.3);
    grid.rg -= smoothstep(1.0, 0.9, 1.0 - fract(uv * 10.0) + 0.04);
    grid.gr += smoothstep(0.1, 0.099, 1.0 - fract(uv) + 0.08);
    grid.gb -= smoothstep(0.01, 0.0, uv.x);
    
    color += grid;

    gl_FragColor = vec4(1.- color,1.0);
}




